/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.rcs.modemcfg;

import com.ibm.hwmca.base.saverest.DataRepApp;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.rcs.modemcfg.ModemConfigBean;
import com.ibm.hwmca.fw.rcs.modemcfg.ModemConfigConstants;
import com.ibm.hwmca.fw.rcs.modemcfg.ModemConfigData;
import com.ibm.hwmca.fw.rcs.modemcfg.ModemConfigManager;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;

public class ModemConfigTasklet
extends PanelTasklet
implements ModemConfigConstants {
    private static final String TRACE_MASKT = "XRCSMCTT";
    private static final String TRACE_MASKF = "XRCSMCTF";
    private static final String TRACE_MASKD = "XRCSMCTD";
    private static final FrameworkClassLogInfo classLogInfo = new FrameworkClassLogInfo(85, "RCS-MCfgTskl");
    private ModemConfigBean modemConfigBean;
    private ModemConfigData modemConfigData;
    private static DataRepApp dataRepApp = DataRepApp.getDataRepApp();

    public ModemConfigTasklet() {
        Trace.trace(TRACE_MASKT, "<> ModemConfigTasklet()");
    }

    public void init() throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> init()");
        Trace.trace(TRACE_MASKT, "<- init()");
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> service(" + request + ", " + response + ")");
        try {
            if (request.isInitialRequest()) {
                this.modemConfigBean = new ModemConfigBean();
                this.modemConfigBean.setBeanName("ModemConfigBean");
                ModemConfigManager modemConfigMgr = ModemConfigManager.getModemConfigManager();
                this.modemConfigData = modemConfigMgr.getModemConfig();
                Trace.trace(TRACE_MASKF, this.modemConfigData.toString());
                String dialType = null;
                dialType = this.modemConfigData.getDialType() == 1 ? "PulseRadioButton" : "ToneRadioButton";
                this.modemConfigBean.setInitDialTypeSelection(dialType);
                this.modemConfigBean.setWaitForDialTone(this.modemConfigData.isWaitForDialTone());
                this.modemConfigBean.setEnableSpeaker(this.modemConfigData.isEnableSpeaker());
                this.modemConfigBean.setDialPrefix(this.modemConfigData.getDialPrefix());
                response.replace("com.ibm.hwmca.fw.rcs.modemcfg.res.ModemConfigRes", "ModemConfigPanel", this.modemConfigBean);
            } else if (request.isDisposed() || request.isCanceled()) {
                response.terminate();
            } else {
                String source = (String)request.getData("Source");
                if (source == null) {
                    source = "";
                }
                Trace.trace(TRACE_MASKF, "source=" + source);
                if (source.equals("")) {
                    Trace.trace(TRACE_MASKF, "Unspecified source");
                    response.noAction();
                } else if (source.equals("ModemConfigPanel")) {
                    this.serviceModemConfigPanel(request, response);
                } else {
                    Trace.trace(TRACE_MASKF, "Unknown source");
                    response.noAction();
                }
            }
        }
        catch (TaskletException te) {
            throw te;
        }
        catch (Exception e) {
            throw new TaskletException(e);
        }
        Trace.trace(TRACE_MASKT, "<- service()");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> logException(" + throwable + ")");
        new FrameworkLog(classLogInfo, 1940, throwable).log();
        Trace.trace(TRACE_MASKT, "<- logException()");
    }

    private void serviceModemConfigPanel(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> serviceModemConfigPanel()");
        String command = (String)request.getData("Command");
        if (command == null) {
            command = "";
        }
        Trace.trace(TRACE_MASKF, "command=" + command);
        if (command.equals("")) {
            Trace.trace(TRACE_MASKF, "Unspecified command");
            response.noAction();
        } else if (command.equals("Commit")) {
            ModemConfigBean bean = (ModemConfigBean)request.getData("Bean");
            if (bean != null) {
                int dialType = 0;
                String[] selection = bean.getDialTypeSelection();
                if (selection.length >= 1 && selection[0].equals("PulseRadioButton")) {
                    dialType = 1;
                }
                this.modemConfigData.setDialType(dialType);
                this.modemConfigData.setWaitForDialTone(bean.isWaitForDialTone());
                this.modemConfigData.setEnableSpeaker(bean.isEnableSpeaker());
                this.modemConfigData.setDialPrefix(bean.getDialPrefix());
                ModemConfigManager modemConfigMgr = ModemConfigManager.getModemConfigManager();
                modemConfigMgr.setModemConfig(this.modemConfigData);
                String sourceDataKey = new ModemConfigManager.SaveRestore().getCustomDataKey();
                dataRepApp.displayCustDataWarning(sourceDataKey, this);
            }
            response.terminate();
        } else if (command.equals("Cancel")) {
            response.terminate();
        } else {
            Trace.trace(TRACE_MASKF, "Unknown command");
            response.noAction();
        }
        Trace.trace(TRACE_MASKT, "<- serviceModemConfigPanel()");
    }
}

